unit StreamUtils;

interface

uses Classes;

procedure SkipNullString(Stream: TStream);
procedure StreamInsert(Stream: TStream; const Data; Size: Cardinal);

implementation

procedure SkipNullString(Stream: TStream);
var C: AnsiChar;
begin
  Stream.Read(C, 1);

  while C <> #0 do
    Stream.Read(C, 1);
end;

procedure StreamInsert(Stream: TStream; const Data; Size: Cardinal);
var
  MemoryStream: TMemoryStream;
  Position: Int64;
begin
  MemoryStream := TMemoryStream.Create;
  try
    MemoryStream.Size := Stream.Size + Size;
    Position := Stream.Position;

    Stream.Position := 0;
    Stream.Read(MemoryStream.Memory^, Position);

    MemoryStream.Position := Position;
    MemoryStream.Write(Data, Size);

    Stream.Read(Pointer(Cardinal(MemoryStream.Memory) + Position + Size)^, Stream.Size - Position);
    Stream.Position := 0;
    MemoryStream.SaveToStream(Stream);
  finally
    MemoryStream.Free;
  end;
end;

end.
