unit LaunchSettings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TSettingsForm = class(TForm)
    ButtonOK: TButton;
    ButtonCancel: TButton;
    GroupBox1: TGroupBox;
    TriggerDebug: TCheckBox;
    ShowFPS: TCheckBox;
    CaptureMouse: TCheckBox;
    DisableAltTab: TCheckBox;
    DisableWinKey: TCheckBox;
    DisableTextures: TCheckBox;
  private
    { Private declarations }
  public
    procedure Open;
  end;

var
  SettingsForm: TSettingsForm;

implementation

uses GameSetup;

{$R *.dfm}

procedure TSettingsForm.Open;
begin
  TriggerDebug.Checked := Settings.ReadBool('SC2Launcher', 'TriggerDebug', False);
  ShowFPS.Checked := Settings.ReadBool('SC2Launcher', 'ShowFPS', False);
  CaptureMouse.Checked := Settings.ReadBool('SC2Launcher', 'CaptureMouse', False);
  DisableAltTab.Checked := Settings.ReadBool('SC2Launcher', 'DisableAltTab', False);
  DisableWinKey.Checked := Settings.ReadBool('SC2Launcher', 'DisableWinKey', False);
  DisableTextures.Checked := Settings.ReadBool('SC2Launcher', 'DisableTextures', False);

  if ShowModal = mrOK then
    begin
      Settings.WriteBool('SC2Launcher', 'TriggerDebug', TriggerDebug.Checked);
      Settings.WriteBool('SC2Launcher', 'ShowFPS', ShowFPS.Checked);
      Settings.WriteBool('SC2Launcher', 'CaptureMouse', CaptureMouse.Checked);
      Settings.WriteBool('SC2Launcher', 'DisableAltTab', DisableAltTab.Checked);
      Settings.WriteBool('SC2Launcher', 'DisableWinKey', DisableWinKey.Checked);
      Settings.WriteBool('SC2Launcher', 'DisableTextures', DisableTextures.Checked);
    end;
end;

end.
